/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hwmca.base.modemcfg;

import com.ibm.hwmca.base.modemcfg.ModemConfigActions;
import com.ibm.hwmca.base.modemcfg.ModemConfigErrorIds;
import com.ibm.hwmca.base.util.BaseMessageText;
import com.ibm.hwmca.base.util.BaseMessageTitle;
import com.ibm.hwmca.fw.log.FrameworkClassLogInfo;
import com.ibm.hwmca.fw.log.FrameworkLog;
import com.ibm.hwmca.fw.msgpanel.CommonMsgApp;
import com.ibm.hwmca.fw.msgpanel.CommonMsgInterface;
import com.ibm.hwmca.fw.tasklet.PanelBean;
import com.ibm.hwmca.fw.tasklet.PanelTaskletRequest;
import com.ibm.hwmca.fw.util.LocalizableText;
import com.ibm.hwmca.fw.util.Trace;
import com.ibm.ui.framework.Capabilities;
import com.ibm.ui.framework.IllegalUserDataException;
import com.ibm.ui.framework.TaskActionEvent;

public class AdvancedModemConfigBean
extends PanelBean
implements ModemConfigErrorIds,
ModemConfigActions {
    private static final String TRACE_MASKT = "HMCGABNT";
    private static final String TRACE_MASKF = "HMCGABNF";
    private static final String TRACE_MASKD = "HMCGABND";
    private static FrameworkClassLogInfo logInfo = new FrameworkClassLogInfo(-89, "ModemCfgABen");
    private static final String[] INVALID_INIT_CODES = new String[]{"L?", "X?", "V?", "H?", "&E4", "&E5", "&E11"};
    private static final String BAD_INIT_CODE_TITLE = "modemcfg.badInitCode.title";
    private static final String BAD_INIT_CODE_ERROR = "modemcfg.badInitCode.error";
    private static final String BAD_INIT_STRING_TITLE = "modemcfg.badInitString.title";
    private static final String BAD_INIT_STRING_WARNING = "modemcfg.badInitString.warning";
    private transient boolean changed;
    private transient String portSpeed;
    private String portSpeedId;
    private transient String dataBits;
    private String dataBitsId;
    private transient String parity;
    private String parityId;
    private transient String stopBits;
    private String stopBitsId;
    private transient String flowControl;
    private String flowControlId;
    private transient String blindDial;
    private String blindDialId;
    private transient String speakerVolume;
    private String speakerVolumeId;
    private String initString;

    public String getPortSpeedChoice() {
        return this.portSpeed;
    }

    public void setPortSpeedChoice(String s) {
        this.changed |= !s.equals(this.portSpeed);
        this.portSpeed = s;
    }

    public String getPortSpeedId() {
        return this.portSpeedId;
    }

    public void setPortSpeedId(String s) {
        this.portSpeedId = s;
    }

    public String getDataBitsChoice() {
        return this.dataBits;
    }

    public void setDataBitsChoice(String s) {
        this.changed |= !s.equals(this.dataBits);
        this.dataBits = s;
    }

    public String getDataBitsId() {
        return this.dataBitsId;
    }

    public void setDataBitsId(String s) {
        this.dataBitsId = s;
    }

    public String getParityChoice() {
        return this.parity;
    }

    public void setParityChoice(String s) {
        this.changed |= !s.equals(this.parity);
        this.parity = s;
    }

    public String getParityId() {
        return this.parityId;
    }

    public void setParityId(String s) {
        this.parityId = s;
    }

    public String getStopBitsChoice() {
        return this.stopBits;
    }

    public void setStopBitsChoice(String s) {
        this.changed |= !s.equals(this.stopBits);
        this.stopBits = s;
    }

    public String getStopBitsId() {
        return this.stopBitsId;
    }

    public void setStopBitsId(String s) {
        this.stopBitsId = s;
    }

    public String getFlowControlChoice() {
        return this.flowControl;
    }

    public void setFlowControlChoice(String s) {
        this.changed |= !s.equals(this.flowControl);
        this.flowControl = s;
    }

    public String getFlowControlId() {
        return this.flowControlId;
    }

    public void setFlowControlId(String s) {
        this.flowControlId = s;
    }

    public String getBlindDialChoice() {
        return this.blindDial;
    }

    public void setBlindDialChoice(String s) {
        this.changed |= !s.equals(this.blindDial);
        this.blindDial = s;
    }

    public String getBlindDialId() {
        return this.blindDialId;
    }

    public void setBlindDialId(String s) {
        this.blindDialId = s;
    }

    public String getSpeakerVolumeChoice() {
        return this.speakerVolume;
    }

    public void setSpeakerVolumeChoice(String s) {
        this.changed |= !s.equals(this.speakerVolume);
        this.speakerVolume = s;
    }

    public String getSpeakerVolumeId() {
        return this.speakerVolumeId;
    }

    public void setSpeakerVolumeId(String s) {
        this.speakerVolumeId = s;
    }

    public String getInitStringEdit() {
        return this.initString;
    }

    public void setInitStringEdit(String s) {
        this.changed |= !s.equals(this.initString);
        this.initString = s;
    }

    public Capabilities getCapabilities() {
        return null;
    }

    public void verifyChanges() throws IllegalUserDataException {
    }

    public void save() {
    }

    public void load() {
        Trace.trace(TRACE_MASKT, "--> load()");
        Trace.trace(TRACE_MASKT, "<-- load()");
    }

    public void prepare() {
        Trace.trace(TRACE_MASKT, "--> prepare()");
        this.setPortSpeedChoice(this.userTaskManager.getValue(this.portSpeedId));
        this.setDataBitsChoice(this.userTaskManager.getValue(this.dataBitsId));
        this.setParityChoice(this.userTaskManager.getValue(this.parityId));
        this.setStopBitsChoice(this.userTaskManager.getValue(this.stopBitsId));
        this.setFlowControlChoice(this.userTaskManager.getValue(this.flowControlId));
        this.setBlindDialChoice(this.userTaskManager.getValue(this.blindDialId));
        this.setSpeakerVolumeChoice(this.userTaskManager.getValue(this.speakerVolumeId));
        this.changed = false;
        Trace.trace(TRACE_MASKT, "<-- prepare()");
    }

    public void panelAction(TaskActionEvent event) {
        Trace.trace(TRACE_MASKT, "--> panelAction(" + event + ")");
        try {
            String element = event.getElementName();
            Trace.trace(TRACE_MASKT, "element=" + element);
            if (element.equals("OkButton")) {
                LocalizableText ans;
                this.userTaskManager.storeAllElements();
                if (!this.getInitStringEdit().toUpperCase().startsWith("AT") && (ans = CommonMsgApp.showMessageBox(this.userTaskManager, (LocalizableText)new BaseMessageTitle(BAD_INIT_STRING_TITLE), new BaseMessageText(BAD_INIT_STRING_WARNING), null, new LocalizableText[]{CommonMsgInterface.YES_BUTTON, CommonMsgInterface.NO_BUTTON})).equals(CommonMsgInterface.NO_BUTTON)) {
                    return;
                }
                String ret = AdvancedModemConfigBean.findInvalidInitCode(this.getInitStringEdit());
                if (ret != null) {
                    CommonMsgApp.showMessageBox(this.userTaskManager, new BaseMessageTitle(BAD_INIT_CODE_TITLE), new BaseMessageText(BAD_INIT_CODE_ERROR, new String[]{ret}));
                    return;
                }
                this.setPortSpeedId(this.userTaskManager.getSelectedElementNames("PortSetupTab.PortSpeedChoice")[0]);
                this.setDataBitsId(this.userTaskManager.getSelectedElementNames("PortSetupTab.DataBitsChoice")[0]);
                this.setParityId(this.userTaskManager.getSelectedElementNames("PortSetupTab.ParityChoice")[0]);
                this.setStopBitsId(this.userTaskManager.getSelectedElementNames("PortSetupTab.StopBitsChoice")[0]);
                this.setFlowControlId(this.userTaskManager.getSelectedElementNames("ModemSetupTab.FlowControlChoice")[0]);
                this.setBlindDialId(this.userTaskManager.getSelectedElementNames("ModemSetupTab.BlindDialChoice")[0]);
                this.setSpeakerVolumeId(this.userTaskManager.getSelectedElementNames("ModemSetupTab.SpeakerVolumeChoice")[0]);
                PanelTaskletRequest request = new PanelTaskletRequest();
                request.setData("source", "advanced");
                request.setData("action", "commit");
                request.setData("bean", this);
                this.postTaskletRequest(request);
            }
            if (element.equals("ModemTestButton")) {
                PanelTaskletRequest request = new PanelTaskletRequest();
                request.setData("source", "advanced");
                request.setData("action", "test_modem");
                request.setData("bean", this);
                this.postTaskletRequest(request);
            } else if (element.equals("CancelButton")) {
                boolean ans;
                this.userTaskManager.storeAllElements();
                if (this.changed && !(ans = CommonMsgApp.showDataChangedConfirmation(this.userTaskManager))) {
                    Trace.trace(TRACE_MASKF, "throw IllegalUserDataException <-- panelAction()");
                    throw new IllegalUserDataException();
                }
                PanelTaskletRequest request = new PanelTaskletRequest();
                request.setData("source", "advanced");
                request.setData("action", "cancel");
                this.postTaskletRequest(request);
            }
        }
        catch (IllegalUserDataException e) {
            throw e;
        }
        catch (Exception e) {
            new FrameworkLog(logInfo, 2437, e).log();
            this.dispose();
        }
        Trace.trace(TRACE_MASKT, "<-- panelAction()");
    }

    private static String findInvalidInitCode(String init) {
        Trace.trace(TRACE_MASKT, "-> findInvalidInitCode(" + init + ")");
        for (int i = 0; i < INVALID_INIT_CODES.length; ++i) {
            String code = INVALID_INIT_CODES[i];
            int matchIndex = 0;
            Trace.trace(TRACE_MASKD, "   checking for " + code);
            for (int initIndex = 0; initIndex < init.length(); ++initIndex) {
                Trace.trace(TRACE_MASKD, "   checking " + init.toUpperCase().charAt(initIndex) + " against " + code.toUpperCase().charAt(matchIndex));
                if (code.charAt(matchIndex) == '?' || init.toUpperCase().charAt(initIndex) == code.toUpperCase().charAt(matchIndex)) {
                    Trace.trace(TRACE_MASKD, "   match!");
                    if (++matchIndex != code.length()) continue;
                    String ret = init.substring(initIndex - matchIndex + 1, initIndex + 1);
                    Trace.trace(TRACE_MASKT, ret + " <- findInvalidInitCode()");
                    return ret;
                }
                if (init.charAt(initIndex) == '&') {
                    ++initIndex;
                }
                matchIndex = 0;
            }
        }
        Trace.trace(TRACE_MASKT, "null <- findInvalidInitCode()");
        return null;
    }
}

